package treeNAlgo;
import treeN.*;

public class ToStringAlgo implements ITreeNAlgo<Object, String, Object> {
  public static ToStringAlgo Singleton = new ToStringAlgo();
  
  private ToStringAlgo() {}
  
  public String caseAt(Integer idx, TreeN<Object> host, Object... nu) {
    switch(idx) {
      case 0: {
        return "[ ]";
      }
      default: {
        String sData= "", sTrees="";
        for(int i = 0;i<idx;i++) {
          sData += host.getDat(i)+" ";
          sTrees += host.getChild(i).execute(toStringHelp,"|  ")+"\n";
        }
        sTrees += host.getChild(idx).execute(toStringHelp,"   ");
        return sData +"\n"+sTrees;
      }
    }
  }
  //----------- helper algo --------------------------------------------------
  final private static ITreeNAlgo<Object, String, String> toStringHelp = new ITreeNAlgo<Object, String, String>() {
    public String caseAt(Integer idx, TreeN<Object> host, String... prefix) {
      switch(idx) {
        case 0: {
          return "|_[ ]";
        }
        default: {
          String sData= "", sTrees="";
          for(int i = 0;i<idx;i++) {
            sData += host.getDat(i)+" ";
            sTrees += prefix[0]
              + host.getChild(i).execute(this,prefix[0]+"|  ")+"\n";
          }
          sTrees += prefix[0] 
            + host.getChild(idx).execute(this, prefix[0]+"   ");
          return "|_ "+sData +"\n"+sTrees;
        }
      }
    }
  };
}
